/*:
 * @target MZ
 * @plugindesc NameBox offset fix for GlobalSlowZoom + HS_ZoomCrispUI_Compat + NRP_MessageWindow
 * @author HS
 */
(() => {
  "use strict";
  if (typeof Window_NameBox === "undefined") return;

  const prm = PluginManager.parameters("NRP_MessageWindow") || {};
  const pAdjX = prm["NameBoxAdjustX"] ?? "";
  const pAdjY = prm["NameBoxAdjustY"] ?? "";
  const pOverlap = String(prm["OverlapNameBox"] || "false") === "true";

  const evalParam = (expr, ctx) => {
    if (!expr) return 0;
    try { return Function("return (" + expr + ")").call(ctx); }
    catch (e) { const n = Number(expr); return isNaN(n) ? 0 : n; }
  };

  const _update = Window_NameBox.prototype.updatePlacement;
  Window_NameBox.prototype.updatePlacement = function () {
    _update.call(this);

    const scn = SceneManager._scene;
    const wl  = scn && scn._windowLayer;
    if (!scn || !wl) return;

    const outsideWL = this.parent !== wl;          // OverlapNameBox=ON でScene直下
    const sX = scn.scale?.x || 1;
    const sY = scn.scale?.y || 1;

    if (outsideWL) {
      // UI等倍（windowLayer と同じ逆スケールを適用）
      if (this.scale.x !== wl.scale.x || this.scale.y !== wl.scale.y) {
        this.scale.set(wl.scale.x, wl.scale.y);
      }

      // NRPの補正（NameBoxAdjust / windowLayer.x,y 加算）がScene拡大で増幅される分を逆補正
      const adjX = evalParam(pAdjX, this);
      const adjY = evalParam(pAdjY, this);
      const addX = pOverlap ? wl.x : 0;
      const addY = pOverlap ? wl.y : 0;

      if (sX !== 1) this.x -= (adjX + addX) * (1 - 1 / sX);
      if (sY !== 1) this.y -= (adjY + addY) * (1 - 1 / sY);

      // にじみ防止（任意）
      this.x = Math.round(this.x);
      this.y = Math.round(this.y);
    }
  };
})();

